/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.ecran;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.base.Outil;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TypeJoueur;
import fr.utt.lo02.uno.jeu.listener.JeuListener;
import fr.utt.lo02.uno.jeu.listener.ListeJoueurListener;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.ecran.Ecran;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.EmplacementJoueur;
import fr.utt.lo02.uno.ui.layout.LayoutLignes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class EcranSalle
extends Ecran
implements ListeJoueurListener,
JeuListener {
    private static final long serialVersionUID = 1L;
    private final EmplacementJoueur[] emplacements;
    private final Salle salle;

    public EcranSalle(Salle salle, boolean editable) {
        this.salle = salle;
        salle.getJeu().addJeuListener(this);
        this.setLayout(new BorderLayout());
        this.setName(salle.getNom());
        this.setImage(Images.getInstance().getImage("fond.jpg"));
        this.setMax(true);
        JPanel centre = new JPanel(new LayoutLignes());
        centre.setOpaque(false);
        JLabel l = new JLabel(String.valueOf(Texte.get("Joueurs de")) + " " + salle.getNom(), 0);
        l.setFont(Configuration.POLICE.deriveFont(20.0f));
        centre.add(l);
        this.emplacements = new EmplacementJoueur[salle.getJeu().getListeJoueurs().getMaxJoueurs()];
        int i = 0;
        while (i < this.emplacements.length) {
            this.emplacements[i] = new EmplacementJoueur(editable);
            centre.add(Box.createRigidArea(new Dimension(1, 10)));
            centre.add(this.emplacements[i]);
            ++i;
        }
        centre.add(Box.createRigidArea(new Dimension(1, 10)));
        JScrollPane jsp = new JScrollPane(centre);
        jsp.setBorder(null);
        jsp.getViewport().setOpaque(false);
        this.add((Component)jsp, "Center");
        salle.getJeu().getListeJoueurs().addListeJoueursListener(this);
        int i2 = 0;
        while (i2 < this.emplacements.length) {
            if (salle.getJeu().getListeJoueurs().joueurExiste(i2)) {
                this.emplacements[i2].setJoueur(salle.getJeu().getListeJoueurs().getJoueur(i2));
            }
            ++i2;
        }
    }

    public abstract Ecran getEcranJeu(Joueur var1, Salle var2);

    public EmplacementJoueur[] getEmplacements() {
        return this.emplacements;
    }

    public Salle getSalle() {
        return this.salle;
    }

    public void ouvreEcran(Joueur j) {
        this.changeEcran(this.getEcranJeu(j, this.salle));
    }

    @Override
    public boolean fermer() {
        this.salle.getJeu().getListeJoueurs().removeListeJoueursListener(this);
        return super.fermer();
    }

    @Override
    public void ajout(int id, Joueur joueur) {
        this.emplacements[id].setJoueur(joueur);
    }

    @Override
    public void retire(int id, Joueur joueur) {
        this.emplacements[id].setVide();
    }

    @Override
    public void nouvellePartie(Partie partie) {
        Joueur[] joueurArray = partie.getJoueurs().getJoueurs();
        int n = joueurArray.length;
        int n2 = 0;
        while (n2 < n) {
            Joueur j = joueurArray[n2];
            if (j != null && j.getType() == TypeJoueur.HUMAIN) {
                try {
                    this.ouvreEcran(j);
                }
                catch (Exception err) {
                    Outil.attendre(500);
                    this.ouvreEcran(j);
                }
            }
            ++n2;
        }
        this.salle.getJeu().removeJeuListener(this);
    }

    @Override
    public void finPartie(Partie partie, ResultatPartie resultats) {
    }
}

