/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.ecran;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.reseau.Paquet;
import fr.utt.lo02.uno.io.reseau.TypePaquet;
import fr.utt.lo02.uno.io.reseau.client.SalleReseau;
import fr.utt.lo02.uno.io.reseau.listeners.ReceiveListener;
import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.temps.CompteARebours;
import fr.utt.lo02.uno.temps.Horloge;
import fr.utt.lo02.uno.temps.HorlogeListener;
import fr.utt.lo02.uno.temps.Periodique;
import fr.utt.lo02.uno.temps.PeriodiqueListener;
import fr.utt.lo02.uno.ui.IconeTache;
import fr.utt.lo02.uno.ui.composant.ecran.EcranPartieReseau;
import fr.utt.lo02.uno.ui.composant.ecran.EcranSalle;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.EmplacementJoueur;
import java.awt.Component;
import java.awt.TrayIcon;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class EcranSalleEnLigne
extends EcranSalle
implements PeriodiqueListener,
ReceiveListener,
HorlogeListener {
    private static final long serialVersionUID = 1L;
    private final JProgressBar avancement;
    private final Periodique periodique;
    private final CompteARebours cpt;
    private final SalleReseau salle;

    public EcranSalleEnLigne(SalleReseau salle) {
        super(salle, false);
        this.salle = salle;
        this.cpt = new CompteARebours();
        this.avancement = new JProgressBar();
        this.periodique = new Periodique(75);
        if (salle.getJeu().getPartie() != null) {
            this.nouvellePartie(salle.getJeu().getPartie());
        } else {
            salle.getClient().addReceiveListener(this);
            this.cpt.addHorlogeListener(this);
            salle.getClient().write(new Paquet(TypePaquet.TEMPS));
            this.avancement.setStringPainted(true);
            this.avancement.setFont(Configuration.POLICE);
            this.add((Component)this.avancement, "South");
            this.setRecherche();
            this.periodique.addPeriodiqueListener(this);
            this.periodique.lancer();
            this.avancement.setValue(100);
        }
        JLabel ip = new JLabel(String.valueOf(Texte.get("Adresse pour rejoindre la partie")) + " : " + salle.getClient().getAdresse().getHostAddress(), 0);
        ip.setFont(Configuration.POLICE.deriveFont(20.0f));
        ip.setToolTipText(Texte.get("Donnez cette adresse a vos amis afin qu'ils puissent rejoindre vos parties"));
        this.add((Component)ip, "North");
    }

    public void setRecherche() {
        EmplacementJoueur[] emplacementJoueurArray = this.getEmplacements();
        int n = emplacementJoueurArray.length;
        int n2 = 0;
        while (n2 < n) {
            EmplacementJoueur e = emplacementJoueurArray[n2];
            e.evenementAnimation();
            ++n2;
        }
    }

    @Override
    public void ajout(int id, Joueur joueur) {
        super.ajout(id, joueur);
        if (!this.estAffiche()) {
            IconeTache.getInstance().message(this.getSalle().getNom(), joueur + " " + Texte.get("rejoint la salle"), TrayIcon.MessageType.INFO);
        }
    }

    @Override
    public void retire(int id, Joueur joueur) {
        super.retire(id, joueur);
        if (!this.estAffiche()) {
            IconeTache.getInstance().message(this.getSalle().getNom(), joueur + " " + Texte.get("quitte la salle"), TrayIcon.MessageType.WARNING);
        }
    }

    @Override
    public boolean fermer() {
        return super.fermer() && this.periodique.terminer() && this.cpt.terminer();
    }

    @Override
    public void action(Periodique p) {
        this.setRecherche();
    }

    @Override
    public void recu(TypePaquet type, IO io) {
        switch (type) {
            case TEMPS: {
                int t = io.nextPositif();
                if (this.avancement != null) {
                    this.avancement.setMaximum(t);
                }
                this.cpt.setTemps(t - 1);
                break;
            }
        }
    }

    @Override
    public void action(Horloge horloge) {
        this.avancement.setValue(horloge.getTemps());
        this.avancement.setString(horloge.toString());
    }

    @Override
    public void nouvellePartie(Partie partie) {
        super.nouvellePartie(partie);
        this.salle.getClient().removeReceiveListener(this);
    }

    @Override
    public EcranPartieReseau getEcranJeu(Joueur joueur, Salle salle) {
        return new EcranPartieReseau(joueur, (SalleReseau)salle);
    }

    @Override
    public void finJeu(List<ResultatPartie> resultats, Jeu jeu) {
    }
}

