/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.ecran;

import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.action.generateur.ControleurPartieHorsLigne;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.Bouton;
import fr.utt.lo02.uno.ui.composant.ecran.EcranAccueil;
import fr.utt.lo02.uno.ui.composant.ecran.EcranPartie;
import fr.utt.lo02.uno.ui.composant.ecran.EcranSalle;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.EcranTabParties;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class EcranSalleHorsLigne
extends EcranSalle
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final AbstractButton retour = new Bouton(Texte.get("Retour"));
    private final AbstractButton lancer = new Bouton(Texte.get("Lancer"));
    private final EcranTabParties parties;
    private EcranPartie ecran;
    private int nombre;

    public EcranSalleHorsLigne(Salle salle) {
        super(salle, true);
        this.parties = new EcranTabParties(salle);
        this.retour.addActionListener(this);
        this.lancer.addActionListener(this);
        JPanel bas = new JPanel();
        bas.setOpaque(false);
        bas.add(this.retour);
        bas.add(this.lancer);
        this.add((Component)bas, "South");
        salle.getJeu().getListeJoueurs().combler();
    }

    @Override
    public void ouvreEcran(Joueur j) {
        EcranPartie e = this.getEcranJeu(j, this.getSalle());
        this.parties.ajout(j, e);
        if (this.ecran == null) {
            this.ecran = e;
        }
        ++this.nombre;
    }

    @Override
    public void nouvellePartie(Partie partie) {
        super.nouvellePartie(partie);
        if (this.nombre > 1) {
            this.changeEcran(this.parties);
        } else {
            this.changeEcran(this.ecran);
            this.parties.fermer();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.retour) {
            this.changeEcran(new EcranAccueil());
        } else if (e.getSource() == this.lancer) {
            this.getSalle().getJeu().nouvellePartie();
        }
    }

    @Override
    public EcranPartie getEcranJeu(Joueur joueur, Salle salle) {
        return new EcranPartie(new ControleurPartieHorsLigne(joueur), joueur, salle);
    }

    @Override
    public void finJeu(List<ResultatPartie> resultats, Jeu jeu) {
    }
}

