/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.ecran;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.io.reseau.client.SalleReseau;
import fr.utt.lo02.uno.jeu.Controleur;
import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.listener.JeuListener;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.temps.Horloge;
import fr.utt.lo02.uno.temps.HorlogeListener;
import fr.utt.lo02.uno.ui.composant.PanelImage;
import fr.utt.lo02.uno.ui.composant.ecran.Ecran;
import fr.utt.lo02.uno.ui.composant.ecran.EcranPartie;
import fr.utt.lo02.uno.ui.composant.ecran.EcranPartieReseau;
import fr.utt.lo02.uno.ui.composant.specialise.score.PanelScorePartie;
import fr.utt.lo02.uno.ui.composant.specialise.score.PanelScores;
import fr.utt.lo02.uno.ui.layout.LayoutLignes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class EcranScores
extends Ecran
implements JeuListener,
HorlogeListener {
    private static final long serialVersionUID = 1L;
    private final Controleur controleur;
    private final JProgressBar restant;
    private final Joueur joueur;
    private final JPanel centre;
    private final Salle salle;

    public EcranScores(Joueur joueur, Controleur controleur, Salle salle) {
        this.salle = salle;
        this.joueur = joueur;
        this.controleur = controleur;
        salle.getJeu().addJeuListener(this);
        this.setImage(Images.getInstance().getImage("fond.jpg"));
        this.setLayout(new BorderLayout());
        this.setName(Texte.get("Scores"));
        this.setMax(true);
        this.setLayout(new BorderLayout());
        this.restant = new JProgressBar(0, Configuration.TEMPS_AFFICHAGE_RESULTATS);
        this.centre = new PanelImage();
        this.centre.setLayout(new LayoutLignes());
        JScrollPane jsp = new JScrollPane(this.centre);
        this.restant.setStringPainted(true);
        this.restant.setFont(Configuration.POLICE);
        this.restant.setValue(Configuration.TEMPS_AFFICHAGE_RESULTATS);
        salle.getJeu().getPartie().getHorloge().addHorlogeListener(this);
        jsp.getViewport().setOpaque(false);
        jsp.setBorder(null);
        this.centre.add(new PanelScores(joueur, salle.getJeu()));
        this.centre.add(Box.createRigidArea(new Dimension(50, 50)));
        List<ResultatPartie> resultats = salle.getJeu().getResultats();
        int i = 0;
        while (i < resultats.size()) {
            this.ajoutResultat(resultats.get(i), i + 1);
            ++i;
        }
        this.add((Component)jsp, "Center");
        this.add((Component)this.restant, "North");
    }

    public void ajoutResultat(ResultatPartie resultat, int numero) {
        this.centre.add(new PanelScorePartie(this.joueur, resultat, numero));
        this.centre.add(Box.createRigidArea(new Dimension(25, 25)));
    }

    @Override
    public void nouvellePartie(Partie partie) {
        this.salle.getJeu().removeJeuListener(this);
        if (this.salle instanceof SalleReseau) {
            this.changeEcran(new EcranPartieReseau(this.joueur, (SalleReseau)this.salle));
        } else {
            this.changeEcran(new EcranPartie(this.controleur, this.joueur, this.salle));
        }
    }

    @Override
    public void finPartie(Partie partie, ResultatPartie resultats) {
    }

    @Override
    public void action(Horloge horloge) {
        this.restant.setValue(this.restant.getValue() - 1);
        String s = String.valueOf(Texte.get("Une nouvelle partie commence dans")) + " " + this.restant.getValue() + " " + Texte.get("secondes");
        if (this.restant.getValue() <= 0) {
            horloge.removeHorlogeListener(this);
            s = String.valueOf(Texte.get("La partie va commencer")) + "...";
        }
        this.restant.setString(s);
    }

    @Override
    public void finJeu(List<ResultatPartie> resultats, Jeu jeu) {
    }
}

