/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise;

import fr.utt.lo02.uno.base.Outil;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.Bouton;
import fr.utt.lo02.uno.ui.composant.ecran.EcranCreerSalle;
import fr.utt.lo02.uno.ui.composant.ecran.EcranRegles;
import fr.utt.lo02.uno.ui.composant.ecran.EcranRejoindreSalle;
import fr.utt.lo02.uno.ui.composant.specialise.LogoUno;
import fr.utt.lo02.uno.ui.interfaces.EcranChangeable;
import fr.utt.lo02.uno.ui.layout.LayoutLignes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class PanelAccueil
extends JPanel
implements Runnable,
ActionListener {
    private static final long serialVersionUID = 1L;
    private final AbstractButton jouer;
    private final AbstractButton horsLigne;
    private final AbstractButton enLigne;
    private final AbstractButton retour;
    private final AbstractButton regles;
    private final AbstractButton[] boutons;
    private final EcranChangeable ecran;
    private final BufferedImage fond;
    private final LogoUno logo;
    private float taille;

    public PanelAccueil(EcranChangeable ecran) {
        this.ecran = ecran;
        this.jouer = new Bouton(Texte.get("Jouer"));
        this.boutons = new AbstractButton[]{this.jouer, this.horsLigne = new Bouton(Texte.get("Partie hors ligne"), new ImageIcon(Images.getInstance().getImage("hors ligne.png"))), this.enLigne = new Bouton(Texte.get("Partie en ligne"), new ImageIcon(Images.getInstance().getImage("online.png"))), this.regles = new Bouton(Texte.get("R\u00e8gles du jeu")), this.retour = new Bouton(Texte.get("Retour"), new ImageIcon(Images.getInstance().getImage("retour.png")))};
        Font police = new Font("Dialog", 1, 18);
        Dimension d = new Dimension(225, 65);
        AbstractButton[] abstractButtonArray = this.boutons;
        int n = this.boutons.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractButton b = abstractButtonArray[n2];
            b.addActionListener(this);
            b.setFont(police);
            b.setPreferredSize(d);
            ++n2;
        }
        this.setLayout(new LayoutLignes(false));
        this.setOpaque(false);
        this.fond = Images.getInstance().getImage("menu uno.png");
        this.logo = new LogoUno();
        this.taille = 1.0f;
        this.setAccueil();
    }

    public void setComposants(Component ... composants) {
        new Thread(this).start();
        this.removeAll();
        this.add(this.logo);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.validate();
        this.repaint();
        Component[] componentArray = composants;
        int n = composants.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            this.add(c);
            this.add(Box.createRigidArea(new Dimension(0, 15)));
            ++n2;
        }
        this.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    public PanelAccueil lancer() {
        this.logo.lancer();
        return this;
    }

    public void terminer() {
        this.taille = 1.0f;
        this.logo.terminer();
    }

    public void setAccueil() {
        this.setComposants(this.jouer, this.regles);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.logo.getWidth() / 2;
        int y = this.logo.getY() + this.logo.getHeight() / 2;
        g.drawImage(this.fond, (this.getWidth() - w) / 2, y, w, (int)((float)(this.getHeight() - y) * this.taille) - 10, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jouer) {
            this.setComposants(this.retour, this.enLigne, this.horsLigne);
        } else if (e.getSource() == this.horsLigne) {
            this.ecran.changeEcran(new EcranCreerSalle(false));
        } else if (e.getSource() == this.regles) {
            this.ecran.changeEcran(new EcranRegles());
        } else if (e.getSource() == this.enLigne) {
            this.ecran.changeEcran(new EcranRejoindreSalle());
        } else if (e.getSource() == this.retour) {
            this.setAccueil();
        }
    }

    @Override
    public void run() {
        AbstractButton b;
        float ajout = 0.1f;
        this.taille = 0.0f;
        AbstractButton[] abstractButtonArray = this.boutons;
        int n = this.boutons.length;
        int n2 = 0;
        while (n2 < n) {
            b = abstractButtonArray[n2];
            b.setVisible(false);
            ++n2;
        }
        Outil.attendre(200);
        while (this.taille < 1.0f) {
            this.taille += ajout;
            if ((double)ajout > 0.001) {
                ajout -= 0.005f;
            }
            this.repaint();
            Outil.attendre(42);
        }
        abstractButtonArray = this.boutons;
        n = this.boutons.length;
        n2 = 0;
        while (n2 < n) {
            b = abstractButtonArray[n2];
            b.setVisible(true);
            ++n2;
        }
    }
}

