/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.Fichiers;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.PanelImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PanelAdresses
extends PanelImage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final List<String> adresses;
    private final JTextField ajout;
    private final JList liste;

    public PanelAdresses() {
        String txtIp;
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(Texte.get("Adresses connues")));
        this.adresses = Fichiers.getInstance().lireLignesFichier("adresses.txt");
        try {
            txtIp = String.valueOf(Texte.get("mon IP")) + " : " + InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            txtIp = "(" + Texte.get("Hors ligne") + ")";
        }
        JLabel ip = new JLabel(txtIp);
        ip.setFont(Configuration.POLICE);
        ip.setForeground(Color.ORANGE);
        ip.setToolTipText(Texte.get("Donnez cette adresse a vos amis afin qu'ils puissent rejoindre vos parties"));
        this.ajout = new JTextField();
        this.ajout.setToolTipText(Texte.get("Ajouter une adresse"));
        this.ajout.setFont(Configuration.POLICE);
        this.ajout.setPreferredSize(new Dimension(150, 40));
        this.ajout.addActionListener(this);
        ModeleAdresses mo = new ModeleAdresses();
        this.liste = new JList(mo);
        this.liste.setFont(Configuration.POLICE);
        this.liste.setForeground(new Color(50, 150, 0));
        this.liste.addKeyListener(mo);
        JScrollPane jsp = new JScrollPane(this.liste);
        jsp.setPreferredSize(new Dimension());
        this.add((Component)ip, "South");
        this.add((Component)jsp, "Center");
        this.add((Component)this.ajout, "North");
    }

    public List<String> getAdresses() {
        return this.adresses;
    }

    public void addListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    public void removeListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    public void change() {
        ListDataEvent evt = new ListDataEvent(this.ajout, 1, 0, this.adresses.size());
        ListDataListener[] listDataListenerArray = (ListDataListener[])this.getListeners(ListDataListener.class);
        int n = listDataListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListDataListener l = listDataListenerArray[n2];
            l.contentsChanged(evt);
            ++n2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String txt = this.ajout.getText();
        if (txt != null && !txt.trim().isEmpty()) {
            this.adresses.add(txt);
            this.ajout.setText("");
            this.change();
        }
    }

    private class ModeleAdresses
    extends KeyAdapter
    implements ListModel {
        private ModeleAdresses() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127 && PanelAdresses.this.liste.getSelectedIndex() >= 0 && PanelAdresses.this.liste.getSelectedIndex() < this.getSize()) {
                PanelAdresses.this.adresses.remove(PanelAdresses.this.liste.getSelectedIndex());
                PanelAdresses.this.change();
            }
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            PanelAdresses.this.addListener(l);
        }

        public String getElementAt(int index) {
            return (String)PanelAdresses.this.adresses.get(index);
        }

        @Override
        public int getSize() {
            return PanelAdresses.this.adresses.size();
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            PanelAdresses.this.removeListener(l);
        }
    }
}

