/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.base.Generateur;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.io.exception.InvalideException;
import fr.utt.lo02.uno.io.reseau.client.SalleReseau;
import fr.utt.lo02.uno.io.reseau.serveur.Serveur;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TypeJoueur;
import fr.utt.lo02.uno.jeu.variantes.TypeJeu;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.Bouton;
import fr.utt.lo02.uno.ui.composant.ecran.Ecran;
import fr.utt.lo02.uno.ui.composant.ecran.EcranAccueil;
import fr.utt.lo02.uno.ui.composant.ecran.EcranSalleEnLigne;
import fr.utt.lo02.uno.ui.composant.ecran.EcranSalleHorsLigne;
import fr.utt.lo02.uno.ui.interfaces.EcranChangeable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelCreerSalle
extends Ecran
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private final AbstractButton valider;
    private final AbstractButton retour;
    private final JTextField nom;
    private final JTextField nomPartie;
    private final EcranChangeable ecran;
    private final boolean enLigne;
    private final JSlider nombre;
    private final JLabel lnombre;
    private final JComboBox type;

    public PanelCreerSalle(boolean enLigne, EcranChangeable ecran) {
        this.enLigne = enLigne;
        this.ecran = ecran;
        this.setMax(true);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints g = new GridBagConstraints();
        g.insets.bottom = 10;
        g.insets.right = 25;
        this.setLayout(layout);
        this.nom = new JTextField(Generateur.getInstance().getNomPrincipal());
        this.nomPartie = new JTextField("Nouvelle partie");
        this.valider = new Bouton(Texte.get("Creer la salle"), new ImageIcon(Images.getInstance().getImage("ok.png").getScaledInstance(16, 16, 16)));
        this.retour = new Bouton(Texte.get("Accueil"), new ImageIcon(Images.getInstance().getImage("retour.png").getScaledInstance(16, 16, 16)));
        this.nombre = new JSlider(2, Configuration.MAX_JOUEUR, 4);
        this.type = new JComboBox<String>(TypeJeu.getNoms());
        JLabel l1 = new JLabel(String.valueOf(Texte.get("Votre nom")) + " : ");
        JLabel l2 = new JLabel(String.valueOf(Texte.get("Nom de la salle")) + " : ");
        JLabel l3 = new JLabel(String.valueOf(Texte.get("Mode de jeu")) + " : ");
        this.lnombre = new JLabel();
        Component box = Box.createRigidArea(new Dimension(1, 15));
        layout.setConstraints(this.retour, g);
        g.gridy += 2;
        layout.setConstraints(l1, g);
        layout.setConstraints(this.nom, g);
        ++g.gridy;
        layout.setConstraints(l2, g);
        layout.setConstraints(this.nomPartie, g);
        ++g.gridy;
        layout.setConstraints(this.lnombre, g);
        layout.setConstraints(this.nombre, g);
        ++g.gridy;
        layout.setConstraints(l3, g);
        layout.setConstraints(this.type, g);
        ++g.gridy;
        layout.setConstraints(box, g);
        ++g.gridy;
        layout.setConstraints(this.valider, g);
        Dimension d = new Dimension(200, 30);
        this.nom.setPreferredSize(d);
        this.nomPartie.setPreferredSize(d);
        this.nombre.setPreferredSize(new Dimension(180, 30));
        this.nom.setFont(Configuration.POLICE);
        this.nomPartie.setFont(Configuration.POLICE);
        l1.setFont(Configuration.POLICE);
        l2.setFont(Configuration.POLICE);
        l3.setFont(Configuration.POLICE);
        this.type.setFont(Configuration.POLICE);
        this.lnombre.setFont(Configuration.POLICE);
        l1.setForeground(Color.YELLOW);
        l2.setForeground(Color.YELLOW);
        l3.setForeground(Color.YELLOW);
        this.lnombre.setForeground(Color.YELLOW);
        this.add(this.retour);
        this.add(l1);
        this.add(this.nom);
        this.add(l2);
        this.add(this.nomPartie);
        this.add(this.lnombre);
        this.add(this.nombre);
        this.add(l3);
        this.add(this.type);
        this.add(box);
        this.add(this.valider);
        this.nombre.addChangeListener(this);
        this.nom.addActionListener(this);
        this.nomPartie.addActionListener(this);
        this.valider.addActionListener(this);
        this.retour.addActionListener(this);
        this.type.addActionListener(this);
        this.setTexteNombre();
    }

    public void setTexteNombre() {
        this.lnombre.setText(String.valueOf(Texte.get("Nombre de joueurs")) + " (" + this.nombre.getValue() + ")");
    }

    public void verifieChamps() throws InvalideException {
        if (this.nom.getText() == null || this.nom.getText().isEmpty()) {
            throw new InvalideException(Texte.get("Vous devez entrer votre nom"));
        }
        if (this.nomPartie.getText() == null || this.nomPartie.getText().isEmpty()) {
            throw new InvalideException(Texte.get("Vous devez entrer un nom pour cette salle"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Generateur.getInstance().setNomPrincipal(this.nom.getText());
        if (e.getSource() == this.retour) {
            this.ecran.changeEcran(new EcranAccueil());
        } else if (e.getSource() == this.type) {
            boolean duel;
            boolean bl = duel = this.type.getSelectedIndex() == TypeJeu.DUEL.ordinal();
            if (duel) {
                this.nombre.setValue(2);
            }
            this.nombre.setEnabled(!duel);
        } else {
            try {
                this.verifieChamps();
                Salle salle = new Salle(TypeJeu.values()[this.type.getSelectedIndex()], this.nombre.getValue(), this.nomPartie.getText());
                if (this.enLigne) {
                    new Serveur(salle).lancer();
                    this.ecran.changeEcran(new EcranSalleEnLigne(new SalleReseau(this.nom.getText())));
                } else {
                    salle.getJeu().getListeJoueurs().ajoutJoueur(new Joueur(TypeJoueur.HUMAIN, this.nom.getText()));
                    this.ecran.changeEcran(new EcranSalleHorsLigne(salle));
                }
            }
            catch (Exception err) {
                JOptionPane.showMessageDialog(this, String.valueOf(Texte.get("Impossible de creer la salle")) + " :\n" + err.getMessage());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setTexteNombre();
    }
}

