/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.animation;

import fr.utt.lo02.uno.io.ImageCartes;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.ui.composant.specialise.animation.Animable;
import fr.utt.lo02.uno.ui.composant.specialise.animation.AnimateurCarte;
import java.awt.Graphics;
import java.awt.Rectangle;

public class AnimationCarte
implements Animable {
    private static final int ITERATIONS = 15;
    private final AnimateurCarte source;
    private final AnimateurCarte cible;
    private final Carte carte;
    private int avancement;

    public AnimationCarte(Carte carte, AnimateurCarte source, AnimateurCarte cible) {
        this.carte = carte;
        this.source = source;
        this.cible = cible;
        cible.commencerCible(carte);
        cible.commencerSource(carte);
    }

    public boolean estFini() {
        return this.avancement > 15;
    }

    @Override
    public void dessiner(Graphics g, Rectangle bounds) {
        Rectangle s = this.source.getPositionSurEcran(this.carte);
        Rectangle p = this.cible.getPositionSurEcran(this.carte);
        Rectangle r = new Rectangle(s.x + (p.x - s.x) * this.avancement / 15, s.y + (p.y - s.y) * this.avancement / 15, s.width + (p.width - s.width) * this.avancement / 15, s.height + (p.height - s.height) * this.avancement / 15);
        boolean visible = this.source.estVisible(this.carte);
        if (!visible && this.cible.estVisible(this.carte)) {
            boolean bl = visible = this.avancement >= 7;
            if (visible) {
                int d = r.width - r.width * this.avancement / 15;
                r.width -= d;
                r.x += d / 2;
            } else {
                int d = r.width * this.avancement / 7;
                r.width -= d;
                r.x += d / 2;
            }
        }
        ImageCartes.getInstance().dessiner(g, r.x, r.y, r.width, r.height, this.carte, visible);
    }

    @Override
    public boolean bouge() {
        ++this.avancement;
        if (this.estFini()) {
            this.source.terminerSource(this.carte);
            this.cible.terminerCible(this.carte);
            return false;
        }
        return true;
    }
}

