/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.animation;

import fr.utt.lo02.uno.base.Outil;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.action.ActionBluff;
import fr.utt.lo02.uno.jeu.action.ActionJoueur;
import fr.utt.lo02.uno.jeu.action.ActionPoseCarte;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.ActionTourListener;
import fr.utt.lo02.uno.jeu.listener.TourJoueurListener;
import fr.utt.lo02.uno.ui.composant.specialise.animation.Animable;
import fr.utt.lo02.uno.ui.composant.specialise.animation.Animation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class PanelAnimations
extends JPanel
implements Runnable,
TourJoueurListener,
ActionTourListener {
    private static final long serialVersionUID = 1L;
    private final List<Animable> animables;
    private final Salle salle;
    private boolean run;

    public PanelAnimations(Salle salle) {
        this.salle = salle;
        this.setOpaque(false);
        this.animables = new ArrayList<Animable>();
    }

    public void lancer() {
        if (!this.run) {
            this.run = true;
            new Thread(this).start();
        }
    }

    public void fermer() {
        this.run = false;
    }

    public void nouvelleAnimation(Animable a) {
        if (!this.run) {
            this.lancer();
        }
        this.animables.add(a);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = 0;
        while (i < this.animables.size()) {
            try {
                this.animables.get(i).dessiner(g, this.getBounds());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public void run() {
        while (this.run) {
            if (!this.animables.isEmpty()) {
                int i = 0;
                while (i < this.animables.size()) {
                    if (!this.animables.get(i).bouge()) {
                        this.animables.remove(i);
                        --i;
                    }
                    ++i;
                }
                this.repaint();
            }
            Outil.attendre(40);
        }
    }

    @Override
    public void debutTour(TourJoueur tour) {
        tour.addActionTourListener(this);
    }

    @Override
    public void finTour(TourJoueur tour) {
        tour.removeActionTourListener(this);
    }

    @Override
    public void peutRejouer(TourJoueur tour) {
    }

    @Override
    public void action(int idAction, ActionJoueur action) {
        block0 : switch (action.getType()) {
            case UNO: {
                this.nouvelleAnimation(new Animation("logo uno.png"));
                break;
            }
            case POSE: {
                switch (((ActionPoseCarte)action).getCarte().getType()) {
                    case INVERSION: {
                        this.nouvelleAnimation(new Animation("inversion.png"));
                        break block0;
                    }
                    case PASSE_TOUR: {
                        this.nouvelleAnimation(new Animation("passer.png"));
                        break block0;
                    }
                    case PLUS_DEUX: {
                        this.nouvelleAnimation(new Animation("+2.png"));
                        break block0;
                    }
                    case PLUS_QUATRE: {
                        this.nouvelleAnimation(new Animation("+4.png"));
                        break block0;
                    }
                }
                break;
            }
            case BLUFF: {
                if (!ActionBluff.aRaison(this.salle.getJeu().getPartie())) break;
                this.nouvelleAnimation(new Animation("bluff.png"));
                break;
            }
            case CONTRE_UNO: {
                this.nouvelleAnimation(new Animation("contre uno.png"));
                break;
            }
        }
    }
}

