/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.jeu;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.base.Outil;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.io.Sons;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.joueur.ListeJoueurs;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.TasCarteListener;
import fr.utt.lo02.uno.jeu.listener.TourJoueurListener;
import fr.utt.lo02.uno.temps.Horloge;
import fr.utt.lo02.uno.temps.HorlogeListener;
import fr.utt.lo02.uno.ui.composant.Chrono;
import fr.utt.lo02.uno.ui.composant.PanelImage;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.PanelJoueur;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;

public class BarreTourJoueurs
extends PanelImage
implements TourJoueurListener,
Runnable,
HorlogeListener,
TasCarteListener {
    public static final int TAILLE = 30;
    private static final long serialVersionUID = 1L;
    private final List<PanelJoueur> joueurs;
    private final BufferedImage sens;
    private final ListeJoueurs liste;
    private final Chrono chrono;
    private Color couleur;
    private int decalage;
    private boolean run;

    public BarreTourJoueurs(List<PanelJoueur> joueurs, ListeJoueurs liste) {
        this.liste = liste;
        this.joueurs = joueurs;
        this.chrono = new Chrono();
        this.setImage(Images.getInstance().getImage("fond transparent.png"));
        this.sens = Images.getInstance().getImage("sens.png");
        this.setMax(true);
    }

    public void lancer() {
        this.run = true;
        new Thread(this).start();
    }

    public void fermer() {
        this.run = false;
    }

    public int getXHorloge() {
        PanelJoueur c = this.getPanelJoueur();
        return c == null ? this.getWidth() / 2 : ((Component)c).getX() + ((Component)c).getWidth() / 2;
    }

    public PanelJoueur getPanelJoueur() {
        for (PanelJoueur pj : this.joueurs) {
            if (pj.getJoueur() != this.liste.getJoueur()) continue;
            return pj;
        }
        throw null;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.couleur);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int x = -30;
        while (x < this.getWidth() + 30) {
            g.drawImage(this.sens, x + (this.liste.sensTrigo() ? this.decalage : -this.decalage), 0, this.liste.sensTrigo() ? 30 : -30, 30, null);
            x += 30;
        }
        super.paintComponent(g);
        try {
            this.chrono.dessiner(g, this.getXHorloge(), 0, 60, 30);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void debutTour(TourJoueur tour) {
        this.chrono.setTemps(Configuration.TEMPS_TOUR);
        this.repaint();
        Sons.getInstance().jouer("pchit.wav");
    }

    @Override
    public void finTour(TourJoueur tour) {
        this.chrono.setTemps(-1);
        this.repaint();
    }

    @Override
    public void peutRejouer(TourJoueur tour) {
    }

    @Override
    public void run() {
        while (this.run) {
            ++this.decalage;
            this.decalage %= 30;
            this.repaint();
            Outil.attendre(60);
        }
    }

    @Override
    public void action(Horloge horloge) {
        this.chrono.setTemps(this.chrono.getTemps() - 1);
    }

    @Override
    public void changeDessus(Carte carte) {
        this.couleur = carte == null || carte.getCouleur() == null ? Color.BLACK : carte.getCouleur().getColor();
    }
}

