/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.jeu;

import fr.utt.lo02.uno.io.ImageCartes;
import fr.utt.lo02.uno.io.Sons;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.ui.listener.CliqueCarteListener;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class CarteGraphique
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private final Carte carte;
    private boolean survol;
    private boolean actif;
    private boolean visible;

    public CarteGraphique(Carte carte, boolean visible) {
        this.carte = carte;
        this.visible = visible;
        this.actif = true;
        this.setOpaque(false);
        this.addMouseListener(this);
    }

    public void setAffiche(boolean visible) {
        this.visible = visible;
    }

    public void setActif(boolean actif) {
        this.actif = actif;
        this.repaint();
    }

    public void setSurvol(boolean survol) {
        this.survol = survol;
        this.repaint();
    }

    public void dessine(Graphics2D g, Color couleur) {
        Composite tmp = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.4f));
        g.setColor(couleur);
        g.fillRoundRect(0, 0, this.getWidth() - this.getWidth() / 40, this.getHeight() - this.getHeight() / 40, this.getWidth() / 7, this.getHeight() / 7);
        g.setComposite(tmp);
    }

    public void addCliqueCarteListener(CliqueCarteListener l) {
        this.listenerList.add(CliqueCarteListener.class, l);
    }

    public void removeCliqueCarteListener(CliqueCarteListener l) {
        this.listenerList.remove(CliqueCarteListener.class, l);
    }

    public Carte getCarte() {
        return this.carte;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ImageCartes.getInstance().dessiner(g, this.getWidth(), this.getHeight(), this.carte, this.visible);
        if (!this.actif) {
            this.dessine((Graphics2D)g, Color.BLACK);
        } else if (this.survol) {
            this.dessine((Graphics2D)g, Color.WHITE);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.actif) {
            Sons.getInstance().jouer("tchic.wav");
            CliqueCarteListener[] cliqueCarteListenerArray = (CliqueCarteListener[])this.listenerList.getListeners(CliqueCarteListener.class);
            int n = cliqueCarteListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                CliqueCarteListener l = cliqueCarteListenerArray[n2];
                l.clique(this);
                ++n2;
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setSurvol(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setSurvol(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

