/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.jeu;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.JeuListener;
import fr.utt.lo02.uno.jeu.listener.PartieListener;
import fr.utt.lo02.uno.ui.composant.ecran.Ecran;
import fr.utt.lo02.uno.ui.composant.ecran.EcranPartie;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

public class EcranTabParties
extends Ecran
implements PartieListener,
JeuListener {
    private static final long serialVersionUID = 1L;
    private final List<Integer> ids;
    private final JTabbedPane tab;
    private final Salle salle;

    public EcranTabParties(Salle salle) {
        this.salle = salle;
        this.setLayout(new BorderLayout());
        this.ids = new ArrayList<Integer>();
        this.tab = new JTabbedPane(3);
        this.tab.setFont(Configuration.POLICE);
        this.add((Component)this.tab, "Center");
        this.setName(salle.getNom());
        salle.getJeu().addJeuListener(this);
    }

    public void ajout(Joueur j, EcranPartie ecranJeu) {
        this.ids.add(this.salle.getJeu().getListeJoueurs().getID(j));
        this.tab.addTab(j.getNom(), new ImageIcon(Images.getInstance().getImage(j.getType().getLienImage()).getScaledInstance(32, 32, 16)), ecranJeu);
    }

    @Override
    public boolean fermer() {
        this.salle.getJeu().getPartie().removePartieListener(this);
        this.salle.getJeu().removeJeuListener(this);
        return super.fermer();
    }

    @Override
    public void debutTour(int id, TourJoueur tour) {
        int index = this.ids.indexOf(id);
        if (index != -1) {
            this.tab.setSelectedIndex(index);
        }
    }

    @Override
    public void nouvellePartie(Partie partie) {
        partie.addPartieListener(this);
    }

    @Override
    public void debutPartie(Partie partie) {
    }

    @Override
    public void passeTour(int id) {
    }

    @Override
    public void finPartie(Partie partie) {
    }

    @Override
    public void finPartie(Partie partie, ResultatPartie resultats) {
    }

    @Override
    public void finJeu(List<ResultatPartie> resultats, Jeu jeu) {
    }
}

