/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.jeu;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.base.Generateur;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TypeJoueur;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.Bouton;
import fr.utt.lo02.uno.ui.composant.PanelImage;
import fr.utt.lo02.uno.ui.interfaces.ChangeTypeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JTextField;

public class EmplacementJoueur
extends PanelImage
implements ActionListener,
ChangeTypeListener {
    private static final long serialVersionUID = 1L;
    private final AbstractButton type;
    private final String recherche;
    private final JTextField nom;
    private Joueur joueur;
    private int etat;

    public EmplacementJoueur(boolean editable) {
        this.setLayout(new BorderLayout(10, 10));
        this.setMax(true);
        this.setImage(Images.getInstance().getImage("fond transparent.png"));
        this.recherche = Texte.get("Recherche d'un joueur");
        this.nom = new JTextField();
        this.nom.setOpaque(false);
        this.nom.setEditable(editable);
        this.nom.setFont(Configuration.POLICE);
        this.type = new Bouton();
        if (editable) {
            this.nom.addActionListener(this);
            this.type.addActionListener(this);
            this.nom.setToolTipText(Texte.get("Entree pour changer le nom du joueur"));
            this.type.setToolTipText(Texte.get("Cliquez pour changer"));
        }
        this.add((Component)this.type, "West");
        this.add((Component)this.nom, "Center");
        this.add(Box.createRigidArea(new Dimension(5, 5)), "South");
        this.add(Box.createRigidArea(new Dimension(5, 5)), "North");
        this.add(Box.createRigidArea(new Dimension(5, 5)), "East");
    }

    public void setJoueur(Joueur joueur) {
        this.joueur = joueur;
        this.nom.setText(joueur.toString());
        this.changeType(joueur.getType());
        joueur.addChangeTypeListener(this);
    }

    public void setVide() {
        this.joueur = null;
        this.nom.setText(null);
        this.type.setIcon(null);
    }

    public void evenementAnimation() {
        if (this.joueur == null) {
            String s = this.recherche;
            int i = 0;
            while (i <= this.etat / 5 % 5) {
                s = String.valueOf(s) + ".";
                ++i;
            }
            this.nom.setText(s);
            this.type.setIcon(new ImageIcon(Images.getInstance().getImage("chargement/" + this.etat % 8 + ".png")));
            ++this.etat;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.type) {
            this.joueur.setType(this.joueur.getType() == TypeJoueur.HUMAIN ? TypeJoueur.ORDINATEUR : TypeJoueur.HUMAIN);
        } else if (e.getSource() == this.nom) {
            if (this.nom.getText() == null || this.nom.getText().trim().isEmpty() || this.nom.getText().equals(this.joueur.getNom())) {
                this.nom.setText(Generateur.getInstance().getNom());
            }
            this.joueur.setNom(this.nom.getText());
        }
    }

    @Override
    public void changeType(TypeJoueur typeJoueur) {
        this.type.setIcon(new ImageIcon(Images.getInstance().getImage(typeJoueur.getLienImage())));
        this.type.setText(typeJoueur.getNom());
    }
}

