/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.jeu;

import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.ensemble.MainJoueur;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.MainListener;
import fr.utt.lo02.uno.ui.composant.PanelImage;
import fr.utt.lo02.uno.ui.composant.specialise.animation.AnimateurCarte;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.CarteGraphique;
import fr.utt.lo02.uno.ui.layout.LayoutMainJoueur;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;

public class MainJoueurGraphique
extends PanelImage
implements MainListener,
AnimateurCarte {
    private static final long serialVersionUID = 1L;
    protected final Map<Carte, CarteGraphique> cartes;
    private final Map<Carte, Component> combles;
    private final boolean visible;

    public MainJoueurGraphique(MainJoueur main) {
        this(main, false);
    }

    public MainJoueurGraphique(MainJoueur main, boolean visible) {
        this.visible = visible;
        this.combles = new HashMap<Carte, Component>();
        this.setLayout(new LayoutMainJoueur());
        this.cartes = new HashMap<Carte, CarteGraphique>();
        main.addMainListener(this);
        this.init(main);
    }

    public void init(MainJoueur main) {
        this.init(main.getCartes());
    }

    public void init(List<Carte> cartes) {
        int i = 0;
        while (i < cartes.size()) {
            this.ajoutCarte(cartes.get(i), i);
            ++i;
        }
    }

    public void activePossibilites(TourJoueur tour) {
        for (Carte c : tour.getActions().getCartesPosables()) {
            this.cartes.get(c).setActif(true);
        }
        this.change();
    }

    public CarteGraphique ajout(Carte carte, CarteGraphique c) {
        this.cartes.put(carte, c);
        return c;
    }

    public CarteGraphique retire(Carte carte) {
        CarteGraphique c = this.cartes.remove(carte);
        return c;
    }

    public void change() {
        this.validate();
        this.repaint();
        if (this.getParent() != null) {
            this.getParent().validate();
            this.getParent().repaint();
        }
    }

    public Rectangle getEmplacementCarte(Carte carte) {
        if (this.combles.containsKey(carte)) {
            return this.combles.get(carte).getBounds();
        }
        return this.cartes.get(carte).getBounds();
    }

    @Override
    public void ajoutCarte(Carte carte, int rang) {
        this.add((Component)this.ajout(carte, new CarteGraphique(carte, this.visible)), this.getComponentCount() - rang);
        this.change();
    }

    @Override
    public void retireCarte(Carte carte, int rang) {
        this.remove(this.retire(carte));
        Component c = Box.createGlue();
        this.combles.put(carte, c);
        this.add(c, this.getComponentCount() - rang);
        this.change();
    }

    @Override
    public void commencerSource(Carte carte) {
        this.commencerCible(carte);
    }

    @Override
    public void commencerCible(Carte carte) {
        this.cartes.get(carte).setVisible(false);
    }

    @Override
    public void terminerSource(Carte carte) {
        try {
            this.remove(this.combles.remove(carte));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.doLayout();
    }

    @Override
    public void terminerCible(Carte carte) {
        if (this.cartes.containsKey(carte)) {
            this.cartes.get(carte).setVisible(true);
        }
        this.doLayout();
    }

    @Override
    public Rectangle getPositionSurEcran(Carte carte) {
        Rectangle r = this.getEmplacementCarte(carte);
        r.x += this.getLocation().x + this.getParent().getLocation().x;
        r.y += this.getLocation().y + this.getParent().getLocation().y;
        return r;
    }

    @Override
    public boolean estVisible(Carte carte) {
        return this.visible;
    }
}

