/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.jeu;

import fr.utt.lo02.uno.io.ImageCartes;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.TourJoueurListener;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.Bouton;
import fr.utt.lo02.uno.ui.composant.PanelImage;
import fr.utt.lo02.uno.ui.listener.PanelActionJoueurListener;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;

public class PanelActionJoueur
extends PanelImage
implements TourJoueurListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int LARGEUR = 150;
    public static final int HAUTEUR = 50;
    private final AbstractButton uno;
    private final AbstractButton contreUno;
    private final AbstractButton passe;
    private final AbstractButton bluff;
    private final AbstractButton pioche;

    public PanelActionJoueur() {
        AbstractButton[] boutons;
        this.setLayout(new FlowLayout(1, 5, 5));
        this.setImage(Images.getInstance().getImage("fond transparent.png"));
        this.setMax(true);
        this.setVisible(false);
        this.uno = new Bouton("UNO !", new ImageIcon(Images.getInstance().getImage("icone_32.png")));
        this.contreUno = new Bouton(String.valueOf(Texte.get("Contre")) + " UNO !", new ImageIcon(Images.getInstance().getImage("pioche.png").getScaledInstance(25, 25, 16)));
        this.passe = new Bouton(Texte.get("Fin tour"), new ImageIcon(Images.getInstance().getImage("passe tour.png").getScaledInstance(25, 25, 16)));
        this.bluff = new Bouton(Texte.get("Bluffer"), new ImageIcon(Images.getInstance().getImage("chat.png").getScaledInstance(25, 25, 16)));
        this.pioche = new Bouton(Texte.get("Piocher"), new ImageIcon(ImageCartes.getInstance().getImage(null, 0).getScaledInstance(20, 30, 16)));
        AbstractButton[] abstractButtonArray = boutons = new AbstractButton[]{this.uno, this.contreUno, this.passe, this.bluff, this.pioche};
        int n = boutons.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractButton b = abstractButtonArray[n2];
            b.addActionListener(this);
            b.setPreferredSize(new Dimension(150, 50));
            ++n2;
        }
    }

    public void addPanelActionJoueurListener(PanelActionJoueurListener l) {
        this.listenerList.add(PanelActionJoueurListener.class, l);
    }

    public void removePanelActionJoueurListener(PanelActionJoueurListener l) {
        this.listenerList.remove(PanelActionJoueurListener.class, l);
    }

    public void testePossibilites(TourJoueur tour) {
        if (tour.getActions().peutUno()) {
            this.add(this.uno);
        }
        if (tour.getActions().peutContreUno()) {
            this.add(this.contreUno);
        }
        if (tour.getActions().peutTerminerTour()) {
            this.add(this.passe);
        }
        if (tour.getActions().peutBluffer()) {
            this.add(this.bluff);
            this.add(this.pioche);
        }
        this.setVisible(this.getComponentCount() > 0);
        this.validate();
        this.repaint();
    }

    public int getHauteur() {
        return this.getComponentCount() * 60;
    }

    @Override
    public void debutTour(TourJoueur tour) {
        this.testePossibilites(tour);
    }

    @Override
    public void finTour(TourJoueur tour) {
        this.removeAll();
        this.setVisible(false);
    }

    @Override
    public void peutRejouer(TourJoueur tour) {
        this.finTour(tour);
        this.debutTour(tour);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanelActionJoueurListener[] ll = (PanelActionJoueurListener[])this.listenerList.getListeners(PanelActionJoueurListener.class);
        if (e.getSource() == this.passe) {
            PanelActionJoueurListener[] panelActionJoueurListenerArray = ll;
            int n = ll.length;
            int n2 = 0;
            while (n2 < n) {
                PanelActionJoueurListener l = panelActionJoueurListenerArray[n2];
                l.passeTour();
                ++n2;
            }
        } else if (e.getSource() == this.uno) {
            PanelActionJoueurListener[] panelActionJoueurListenerArray = ll;
            int n = ll.length;
            int n3 = 0;
            while (n3 < n) {
                PanelActionJoueurListener l = panelActionJoueurListenerArray[n3];
                l.uno();
                ++n3;
            }
        } else if (e.getSource() == this.contreUno) {
            PanelActionJoueurListener[] panelActionJoueurListenerArray = ll;
            int n = ll.length;
            int n4 = 0;
            while (n4 < n) {
                PanelActionJoueurListener l = panelActionJoueurListenerArray[n4];
                l.contreUno();
                ++n4;
            }
        } else {
            PanelActionJoueurListener[] panelActionJoueurListenerArray = ll;
            int n = ll.length;
            int n5 = 0;
            while (n5 < n) {
                PanelActionJoueurListener l = panelActionJoueurListenerArray[n5];
                l.contreBluff(e.getSource() == this.bluff);
                ++n5;
            }
        }
    }
}

