/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.jeu;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.jeu.carte.Couleur;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.TourJoueurListener;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.PanelImage;
import fr.utt.lo02.uno.ui.listener.ChoixCouleurListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;

public class PanelChoixCouleur
extends PanelImage
implements TourJoueurListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private final AbstractButton[] boutons;

    public PanelChoixCouleur() {
        this.setLayout(new BorderLayout(25, 25));
        this.setImage(Images.getInstance().getImage("fond transparent.png"));
        this.setMax(true);
        JLabel titre = new JLabel(Texte.get("Choisir une couleur"), 0);
        titre.setOpaque(true);
        titre.setBackground(Color.WHITE);
        titre.setFont(Configuration.POLICE);
        PanelImage centre = new PanelImage();
        this.boutons = new JButton[Couleur.values().length];
        int i = 0;
        while (i < this.boutons.length) {
            Couleur c = Couleur.values()[i];
            JButton b = new JButton(c.getNom());
            b.setFont(Configuration.POLICE);
            b.setPreferredSize(new Dimension(100, 50));
            b.addActionListener(this);
            b.setBackground(c.getColor());
            b.setCursor(Cursor.getPredefinedCursor(12));
            centre.add(b);
            this.boutons[i] = b;
            ++i;
        }
        this.add((Component)centre, "Center");
        this.add((Component)titre, "North");
        this.add(Box.createRigidArea(new Dimension(5, 5)), "South");
        this.add(Box.createRigidArea(new Dimension(5, 5)), "West");
        this.add(Box.createRigidArea(new Dimension(5, 5)), "East");
        this.setVisible(false);
    }

    public void testeOuverture(TourJoueur tour) {
        this.setVisible(tour.getActions().peutChoisirCouleur());
    }

    public int getIDBouton(Object object) {
        int i = 0;
        while (i < this.boutons.length) {
            if (this.boutons[i] == object) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Le composant ne correspond a aucun bouton");
    }

    public void addChoixCouleurListener(ChoixCouleurListener l) {
        this.listenerList.add(ChoixCouleurListener.class, l);
    }

    public void removeChoixCouleurListener(ChoixCouleurListener l) {
        this.listenerList.remove(ChoixCouleurListener.class, l);
    }

    @Override
    public void debutTour(TourJoueur tour) {
        this.testeOuverture(tour);
    }

    @Override
    public void finTour(TourJoueur tour) {
        this.setVisible(false);
    }

    @Override
    public void peutRejouer(TourJoueur tour) {
        this.testeOuverture(tour);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Couleur couleur = Couleur.values()[this.getIDBouton(e.getSource())];
        ChoixCouleurListener[] choixCouleurListenerArray = (ChoixCouleurListener[])this.getListeners(ChoixCouleurListener.class);
        int n = choixCouleurListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChoixCouleurListener l = choixCouleurListenerArray[n2];
            l.choixCouleur(couleur);
            ++n2;
        }
    }
}

