/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.jeu;

import fr.utt.lo02.uno.io.ImageCartes;
import fr.utt.lo02.uno.io.Sons;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.ensemble.TasDeCarte;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.TasCarteListener;
import fr.utt.lo02.uno.jeu.listener.TourJoueurListener;
import fr.utt.lo02.uno.ui.composant.specialise.animation.AnimateurCarte;
import fr.utt.lo02.uno.ui.listener.PanelTasCarteListener;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class PanelTasCartes
extends JPanel
implements MouseListener,
TasCarteListener,
TourJoueurListener,
AnimateurCarte {
    private static final long serialVersionUID = 1L;
    private final TasDeCarte tas;
    private final boolean affiche;
    private boolean survol;
    private boolean actif;
    private boolean dessusVisible;

    public PanelTasCartes(boolean affiche, TasDeCarte tas) {
        this.affiche = affiche;
        this.tas = tas;
        this.dessusVisible = true;
        this.setOpaque(false);
        this.addMouseListener(this);
        tas.addTasCarteListener(this);
    }

    public TasDeCarte getTas() {
        return this.tas;
    }

    public int getDecalage() {
        return this.tas.getNombre() / 5;
    }

    public void setActif(boolean actif) {
        this.actif = actif;
        this.repaint();
    }

    public void setDessusVisible(boolean dessusVisible) {
        this.dessusVisible = dessusVisible;
        this.repaint();
    }

    public void addPanelTasCarteListener(PanelTasCarteListener l) {
        this.listenerList.add(PanelTasCarteListener.class, l);
    }

    public void removePanelTasCarteListener(PanelTasCarteListener l) {
        this.listenerList.remove(PanelTasCarteListener.class, l);
    }

    public Rectangle getZoneDessin() {
        return new Rectangle(0, 0, this.getWidth() - this.getDecalage(), this.getHeight() - this.getDecalage());
    }

    @Override
    public void debutTour(TourJoueur tour) {
        this.setActif(tour.getActions().peutPiocher());
    }

    @Override
    public void finTour(TourJoueur tour) {
        this.setActif(false);
    }

    @Override
    public void peutRejouer(TourJoueur tour) {
        this.setActif(tour.getActions().peutPiocher());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle r = this.getZoneDessin();
        Graphics2D g2d = (Graphics2D)g;
        Composite tmp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 0.4f));
        g.fillRoundRect(this.getWidth() / 100, this.getDecalage(), this.getWidth() - this.getWidth() / 100, r.height, this.getWidth() / 5, this.getHeight() / 5);
        g2d.setComposite(tmp);
        int y = this.getDecalage();
        while (y >= 0) {
            if (this.dessusVisible) {
                ImageCartes.getInstance().dessiner(g, 0, y, r.width, r.height, this.tas.getCarte(), this.affiche);
            } else if (this.tas.getNombre() > 1) {
                ImageCartes.getInstance().dessiner(g, 0, y, r.width, r.height, this.tas.getCartePrecedente(), this.affiche);
            }
            y -= 2;
        }
        if (this.survol && this.actif) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.4f));
            g.setColor(Color.WHITE);
            g.fillRoundRect(0, 0, r.width - 1, r.height - 2, this.getWidth() / 5, this.getHeight() / 5);
            g2d.setComposite(tmp);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.actif) {
            Sons.getInstance().jouer("tchic.wav");
            PanelTasCarteListener[] panelTasCarteListenerArray = (PanelTasCarteListener[])this.listenerList.getListeners(PanelTasCarteListener.class);
            int n = panelTasCarteListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PanelTasCarteListener l = panelTasCarteListenerArray[n2];
                l.clique(this);
                ++n2;
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.survol = true;
        this.getParent().repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.survol = false;
        this.getParent().repaint();
    }

    @Override
    public Rectangle getPositionSurEcran(Carte carte) {
        Rectangle r = this.getZoneDessin();
        r.x += this.getParent().getLocation().x + this.getLocation().x;
        r.y += this.getParent().getLocation().y + this.getLocation().y;
        return r;
    }

    @Override
    public boolean estVisible(Carte carte) {
        return this.affiche;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void changeDessus(Carte carte) {
        this.repaint();
    }

    @Override
    public void terminerSource(Carte carte) {
        this.setDessusVisible(true);
    }

    @Override
    public void terminerCible(Carte carte) {
        this.terminerSource(carte);
    }

    @Override
    public void commencerSource(Carte carte) {
        this.setDessusVisible(false);
    }

    @Override
    public void commencerCible(Carte carte) {
        this.commencerSource(carte);
    }
}

