/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.score;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.PanelImage;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.CarteGraphique;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelResultatJoueur
extends PanelImage {
    private static final long serialVersionUID = 1L;
    private final boolean principal;

    public PanelResultatJoueur(boolean principal, Joueur joueur, List<Carte> cartes) {
        this.principal = principal;
        this.setLayout(new BorderLayout());
        this.setImage(Images.getInstance().getImage("fond transparent.png"));
        this.setMax(true);
        JLabel l = new JLabel(joueur.getNom(), new ImageIcon(Images.getInstance().getImage(joueur.getType().getLienImage())), 0);
        l.setFont(Configuration.POLICE);
        JPanel centre = new JPanel();
        centre.setOpaque(false);
        int pts = 0;
        for (Carte c : cartes) {
            CarteGraphique cg = new CarteGraphique(c, true);
            cg.setToolTipText(c.toString());
            cg.setActif(true);
            cg.setPreferredSize(new Dimension(40, 60));
            centre.add(cg);
            pts += c.getValeurPoints();
        }
        JLabel points = new JLabel("(" + pts + ")    ", 0);
        points.setForeground(Color.YELLOW);
        points.setFont(Configuration.POLICE);
        JLabel gagnant = new JLabel(Texte.get("gagnant"), 0);
        gagnant.setForeground(Color.BLACK);
        gagnant.setFont(Configuration.POLICE);
        this.add((Component)l, "West");
        this.add((Component)(cartes.isEmpty() ? gagnant : centre), "Center");
        this.add((Component)points, "East");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.principal) {
            g.drawImage(Images.getInstance().getImage("survol.png"), 0, 0, this.getWidth(), this.getHeight(), null);
        }
    }
}

