/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.specialise.score;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.variantes.JeuEquipes;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.PanelImage;
import fr.utt.lo02.uno.ui.layout.LayoutLignes;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class PanelScores
extends PanelImage {
    private static final long serialVersionUID = 1L;

    public PanelScores(Joueur joueur, Jeu jeu) {
        this.setImage(Images.getInstance().getImage("tapis.jpg"));
        this.setMax(true);
        this.setLayout(new GridLayout());
        switch (jeu.getType()) {
            case CLASSIQUE: 
            case DUEL: 
            case CHALLENGE: {
                for (Map.Entry<Joueur, Integer> e : ResultatPartie.getPoints(jeu.getResultats()).entrySet()) {
                    PanelImage p = new PanelImage(new LayoutLignes());
                    Joueur j = e.getKey();
                    if (j == joueur) {
                        p.setImage(Images.getInstance().getImage("survol.png"));
                    }
                    JLabel l1 = new JLabel(j.getNom(), new ImageIcon(Images.getInstance().getImage(j.getType().getLienImage())), 0);
                    l1.setFont(Configuration.POLICE);
                    JLabel l2 = new JLabel(e.getValue() + " " + Texte.get("points"), 0);
                    l2.setFont(Configuration.POLICE.deriveFont(25.0f));
                    l2.setForeground(Color.YELLOW);
                    p.add(l1);
                    p.add(l2);
                    this.add(p);
                }
                break;
            }
            case EQUIPES: {
                JeuEquipes j = (JeuEquipes)jeu;
                int i = 0;
                while (i < 2) {
                    PanelImage p = new PanelImage(new LayoutLignes());
                    if (i == j.getEquipe(joueur)) {
                        p.setImage(Images.getInstance().getImage("survol.png"));
                    }
                    JLabel l1 = new JLabel(String.valueOf(Texte.get("Equipe")) + " " + (i + 1), new ImageIcon(Images.getInstance().getImage("hors ligne.png")), 0);
                    l1.setFont(Configuration.POLICE);
                    JLabel l2 = new JLabel(String.valueOf(j.getPoints(i)) + " " + Texte.get("points"), 0);
                    l2.setFont(Configuration.POLICE.deriveFont(25.0f));
                    l2.setForeground(Color.YELLOW);
                    p.add(l1);
                    p.add(l2);
                    this.add(p);
                    ++i;
                }
                break;
            }
        }
    }
}

