/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class LayoutCases
implements LayoutManager {
    private final Dimension taille;
    private int espace;

    public LayoutCases(Dimension taille) {
        this.taille = taille;
    }

    public LayoutCases(int taille) {
        this(new Dimension(taille, taille));
    }

    public LayoutCases(int taille, int espace) {
        this(taille);
        this.espace = espace;
    }

    public LayoutCases setEspace(int espace) {
        this.espace = espace;
        return this;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        int x = this.espace;
        int y = this.espace;
        Component[] componentArray = parent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setBounds(x, y, this.taille.width, this.taille.height);
            if ((x += this.taille.width + this.espace) + this.taille.width > parent.getWidth()) {
                y += this.taille.height + this.espace;
                x = this.espace;
            }
            ++n2;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(this.taille.width, this.taille.height);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension d = new Dimension(this.espace, this.espace);
        int i = 0;
        while (i < parent.getComponentCount()) {
            d.width += this.taille.width + this.espace;
            if (d.width + this.taille.width > parent.getWidth()) {
                d.height += this.taille.height + this.espace;
            }
            ++i;
        }
        return d;
    }
}

